<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('Service Show'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style-lib'); ?>
    <link href="<?php echo e(asset('assets/admin/css/select.css')); ?>" rel="stylesheet"/>
    <link href="<?php echo e(asset('assets/admin/css/jquery-ui.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>


    <div class="page-header card card-primary m-0 m-md-4 my-4 m-md-0 p-5">
        <div class="row ">
            <div class="col-xl-10">
                <form action="<?php echo e(route('admin.service-search')); ?>" method="get">
                    <div class="row">
                        <div class="col-md-4 col-xl-3">
                            <div class="form-group">
                                <input type="text" name="service" value="<?php echo e(@request()->service); ?>" class="form-control"
                                       placeholder="<?php echo app('translator')->get('Type Here'); ?>">
                            </div>
                        </div>

                        <div class="col-md-4 col-xl-3">
                            <div class="form-group">
                                <select name="category" id="category" class="form-control statusfield">
                                    <option value="-1"
                                            <?php if(@request()->category == '-1'): ?> selected <?php endif; ?>><?php echo app('translator')->get('All Category'); ?></option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"
                                                <?php if(@request()->category == $category->id): ?> selected <?php endif; ?>><?php echo app('translator')->get($category->category_title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4 col-xl-3">
                            <div class="form-group">
                                <select name="provider" id="provider" class="form-control statusfield">
                                    <option value="-1"
                                            <?php if(@request()->provider == '-1'): ?> selected <?php endif; ?>><?php echo app('translator')->get('All Provider'); ?></option>
                                    <?php $__currentLoopData = $apiProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($provider->id); ?>"
                                                <?php if(@request()->provider == $provider->id): ?> selected <?php endif; ?>><?php echo app('translator')->get($provider->api_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-4 col-xl-3">
                            <div class="form-group">
                                <select name="status" class="form-control">
                                    <option value="-1"
                                            <?php if(@request()->status == '-1'): ?> selected <?php endif; ?>><?php echo app('translator')->get('All Status'); ?></option>
                                    <option value="1"
                                            <?php if(@request()->status == '1'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Active'); ?></option>
                                    <option value="0"
                                            <?php if(@request()->status == '0'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Inactive'); ?></option>
                                </select>
                            </div>
                        </div>


                        <div class="col-md-4 col-xl-3">
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary w-100 w-sm-auto"><i
                                        class="fas fa-search"></i> <?php echo app('translator')->get('Search'); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <div class="col-xl-2 ">

                <div class="d-flex justify-content-start justify-content-xl-end">
                    <button type="button" class="btn btn-sm btn-primary  mr-3" data-toggle="modal"
                            data-target="#importServiceModal">
                        <span> <?php echo app('translator')->get('Import Services'); ?></span>
                    </button>

                    <div class="dropdown">
                        <button class="btn btn-dark  btn-sm dropdown-toggle" type="button" id="dropdownMenuButton"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <span><i class="fas fa-bars pr-2"></i> <?php echo app('translator')->get('Action'); ?></span>
                        </button>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <button class="dropdown-item" type="button" data-toggle="modal"
                                    data-target="#all_active"><?php echo app('translator')->get('Active'); ?></button>
                            <button class="dropdown-item" type="button" data-toggle="modal"
                                    data-target="#all_deactive"><?php echo app('translator')->get('Inactive'); ?></button>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>



    <div id="accordion" class="accordion-service">
        <?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="card card-primary m-0 m-md-4 my-1 m-md-0">
                <div class="card-header" id="faqhead<?php echo e(slug($key)); ?>">
                    <a href="#" class="btn btn-header-link" data-toggle="collapse"
                       data-target="#faq<?php echo e(slug($key)); ?>" aria-expanded="true"
                       aria-controls="faq<?php echo e(slug($key)); ?>">
                        <?php echo app('translator')->get($key); ?>
                    </a>
                </div>

                <div id="faq<?php echo e(slug($key)); ?>" class="collapse <?php if($loop->first): ?> show <?php endif; ?>"
                     aria-labelledby="faqhead<?php echo e(slug($key)); ?>" data-parent="#accordion">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table
                                class="categories-show-table table table-hover table-striped table-bordered text-right text-lg-center">
                                <thead class="thead-primary">
                                <tr class="text-center">
                                    <th scope="col">
                                        <input type="checkbox"
                                               class="form-check-input check-all tic-check check-all-tic"
                                               id="cat-tic-<?php echo e($key); ?>"
                                               name="check-all">
                                        <label for="cat-tic-<?php echo e($key); ?>"></label>
                                    </th>
                                    <th scope="col"><?php echo app('translator')->get('ID'); ?></th>
                                    <th scope="col" class="text-left"><?php echo app('translator')->get('Name'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Provider'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Drip-Feed'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $service; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="text-center check-box-width-50">
                                            <input type="checkbox"
                                                   class="form-check-input row-tic tic-check row-tic-check"
                                                   id="service-tic-<?php echo e($row->id); ?>"
                                                   name="check" value="<?php echo e($row->id); ?>" data-id="<?php echo e($row->id); ?>">
                                            <label for="service-tic-<?php echo e($row->id); ?>"></label>
                                        </td>
                                        <td data-label="<?php echo app('translator')->get('ID'); ?>"><?php echo e($row->id); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Name'); ?>" class="text-right text-lg-left">
                                            <a href="javascript:void(0)" data-container="body" data-toggle="popover"
                                               data-placement="top" data-content="<?php echo e($row->service_title); ?>">
                                                <?php echo e(\Str::limit($row->service_title, 30)); ?>

                                            </a>
                                        </td>
                                        <td data-label="<?php echo app('translator')->get('Provider'); ?>">
                                            <?php echo e(optional($row->provider)->api_name ?? 'N/A'); ?>

                                        </td>


                                        <td data-label="<?php echo app('translator')->get('Drip-Feed'); ?>">
                                            <span
                                                class="badge badge-pill <?php echo e($row->drip_feed == 0 ? 'badge-danger' : 'badge-success'); ?>"><?php echo e($row->drip_feed == 0 ? 'Inactive' : 'Active'); ?></span>
                                        </td>
                                        <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                            <span
                                                class="badge badge-pill <?php echo e($row->service_status == 0 ? 'badge-danger' : 'badge-success'); ?>"><?php echo e($row->service_status == 0 ? 'Inactive' : 'Active'); ?></span>
                                        </td>


                                        <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                            <a href="<?php echo e(route('admin.service.edit',['id'=>$row->id])); ?>"
                                               class="btn btn-primary btn-rounded btn-sm" title="<?php echo app('translator')->get('Edit'); ?>">
                                                <i class="fa fa-edit"
                                                   aria-hidden="true"></i>
                                            </a>

                                            <?php if($row->service_status == 0): ?>
                                                <a href="javascript:void(0)"
                                                   class="btn btn-success btn-rounded btn-sm status-change"
                                                   data-toggle="modal"
                                                   data-target="#statusMoldal"
                                                   data-route="<?php echo e(route('admin.service.status.change',['id'=>$row->id])); ?>">
                                                    <i class="fa fa-check-circle  "
                                                       aria-hidden="true"></i>
                                                </a>
                                            <?php else: ?>
                                                <a href="javascript:void(0)"
                                                   class="btn btn-danger btn-rounded btn-sm status-change"
                                                   data-toggle="modal"
                                                   data-target="#statusMoldal"
                                                   data-route="<?php echo e(route('admin.service.status.change',['id'=>$row->id])); ?>">
                                                    <i class="fa fa-times-circle  "
                                                       aria-hidden="true"></i>
                                                </a>

                                            <?php endif; ?>


                                            <button type="button" class="btn btn-secondary btn-rounded btn-sm"
                                                    data-toggle="modal" data-target="#description" id="details"
                                                    data-toggle="tooltip" title="Details"
                                                    data-servicetitle="<?php echo e($row->service_title); ?>"
                                                    data-description="<?php echo e($row->description); ?>"
                                                    data-rateper="<?php echo e($row->price); ?>"
                                                    data-orderlimit="<?php echo e($row->min_amount .' - ' .$row->max_amount); ?>">
                                                <i class="fa fa-info-circle"></i></button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>


        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="card card-primary m-0 mx-md-4 my-2 m-md-0">
                <div class="card-body">
                    <h4 class="card-title"><?php echo app('translator')->get('No Data Found!'); ?></h4>
                </div>
            </div>
        <?php endif; ?>
    </div>


    <div class="modal fade" id="statusMoldal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog " role="document">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h5 class="modal-title"><?php echo app('translator')->get('Confirm Status Change'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="" method="post" id="statusForm">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <p><?php echo app('translator')->get('Are you really want to change the current status of the category'); ?></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-dismiss="modal"><span> <?php echo app('translator')->get('Cancel'); ?></span>
                        </button>
                        <button type="submit" class="btn btn-primary"><span>  <?php echo app('translator')->get('Change Status'); ?></span></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="importServiceModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog " role="document">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h5 class="modal-title"><?php echo app('translator')->get('Confirm Import Services'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.api.services')); ?>" method="post" id="getServicesForm">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <select class="form-control" name="api_provider_id">
                                <option selected="" disabled><?php echo app('translator')->get('Select API Provider'); ?></option>
                                <?php $__currentLoopData = $apiProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apiProvider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($apiProvider->id); ?>"><?php echo app('translator')->get($apiProvider->api_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-dismiss="modal"><span> <?php echo app('translator')->get('Cancel'); ?></span>
                        </button>
                        <button type="submit" class="btn btn-primary"><span>  <?php echo app('translator')->get('Get Services'); ?></span></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="description">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h4 class="modal-title" id="title"></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <div class="modal-body">
                    <p id="servicedescription"></p>
                    <p><strong><?php echo e(trans('Rate Per 1k')); ?> :</strong> <span
                            id="rateper"></span> <?php echo e(config('basic.currency')); ?> </p>
                    <p><strong><?php echo e(trans('Order Limit')); ?> :</strong> <span id="orderlimit"></span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                </div>

            </div>
        </div>
    </div>


    <div class="modal fade" id="all_active" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h4 class="modal-title" id="title"><?php echo app('translator')->get('Active Confirmation'); ?></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <h2><i class="fas fa-sync-alt position-absolute"></i></h2>
                    <div class="body-centent pl-5">
                        <p><?php echo app('translator')->get('Are you really want to active the category'); ?></p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-dismiss="modal"><?php echo app('translator')->get('No'); ?>
                    </button>
                    <form action="" method="post">
                        <?php echo csrf_field(); ?>
                        <a href="" class="btn btn-primary active-yes"><span><?php echo app('translator')->get('Yes'); ?></span></a>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="all_deactive" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header modal-colored-header bg-primary">
                    <h4 class="modal-title" id="title"><?php echo app('translator')->get('DeActive Confirmation'); ?></h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <div class="modal-body">
                    <h2><i class="fas fa-sync-alt position-absolute"></i></h2>
                    <div class="body-centent pl-5">
                        <p><?php echo app('translator')->get('Are you really want to Inactive the category'); ?></p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-dismiss="modal"><span><?php echo app('translator')->get('No'); ?></span></button>
                    <form action="" method="post">
                        <?php echo csrf_field(); ?>
                        <a href="" class="btn btn-primary deactive-yes"><span><?php echo app('translator')->get('Yes'); ?></span></a>
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/jquery-ui.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function () {
            "use strict";
            $(document).on('click', '.check-all-tic', function () {
                $(this).closest('table').find('input:checkbox').prop('checked', this.checked);
            });

            $(document).on('click', '.row-tic-check', function () {
                if ($(this).closest('table').find('.row-tic-check').length == $(this).closest('table').find('.row-tic-check:checked').length) {
                    $(this).closest('table').find('.check-all-tic').prop('checked', this.checked);
                } else {
                    $(this).closest('table').find('.check-all-tic').prop('checked', false);
                }
            });

            $(document).on('click', '.status-change', function () {
                let route = $(this).data('route');
                $('#statusForm').attr('action', route);
            });
            $(document).on('click', '#details', function () {
                var title = $(this).data('servicetitle');
                var description = $(this).data('description');
                var rateper = $(this).data('rateper');
                var orderlimit = $(this).data('orderlimit');
                $('#title').text(title);
                $('#servicedescription').text(description);
                $('#rateper').text(rateper);
                $('#orderlimit').text(orderlimit);
            });
            $(document).on('click', '.dropdown-menu', function (e) {
                e.stopPropagation();
            });

            $('.statusfield').select2({'width': '100%'});


            //multiple active
            $(document).on('click', '.active-yes', function (e) {
                e.preventDefault();
                var allVals = [];
                $(".row-tic:checked").each(function () {
                    allVals.push($(this).attr('data-id'));
                });

                if (allVals.length > 0) {
                    var strIds = allVals.join(",");
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': $('meta[name="csrf_token"]').attr('content')},
                        url: "<?php echo e(route('admin.service-multiple-active')); ?>",
                        data: {strIds: strIds},
                        datatType: 'json',
                        type: "get",
                        success: function (data) {
                            if (data.success == 1) {
                                location.reload();
                            }
                        }
                    });
                } else {
                    var strIds = allVals.join(",");
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': $('meta[name="csrf_token"]').attr('content')},
                        url: "<?php echo e(route('admin.service-multiple-active')); ?>",
                        data: {strIds: strIds},
                        datatType: 'json',
                        type: "get",
                        success: function (data) {
                            if (data.error == 1) {
                                location.reload();
                            }
                        }
                    });
                }
            });
            //multiple deactive
            $(document).on('click', '.deactive-yes', function (e) {
                e.preventDefault();
                var allVals = [];
                $(".row-tic:checked").each(function () {
                    allVals.push($(this).attr('data-id'));
                });

                if (allVals.length > 0) {
                    var strIds = allVals.join(",");
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': $('meta[name="csrf_token"]').attr('content')},
                        url: "<?php echo e(route('admin.service-multiple-deactive')); ?>",
                        data: {strIds: strIds},
                        datatType: 'json',
                        type: "get",
                        success: function (data) {
                            if (data.success == 1) {
                                location.reload();
                            }
                        }
                    });
                } else {
                    var strIds = allVals.join(",");
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': $('meta[name="csrf_token"]').attr('content')},
                        url: "<?php echo e(route('admin.service-multiple-deactive')); ?>",
                        data: {strIds: strIds},
                        datatType: 'json',
                        type: "get",
                        success: function (data) {
                            if (data.error == 1) {
                                location.reload();
                            }
                        }
                    });
                }
            });

        });
    </script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\SMM_200823\project\resources\views/admin/pages/services/search-service.blade.php ENDPATH**/ ?>