<!DOCTYPE html >
<!--[if lt IE 7 ]><html class="ie ie6" lang="en"> <![endif]-->
<!--[if IE 7 ]><html class="ie ie7" lang="en"> <![endif]-->
<!--[if IE 8 ]><html class="ie ie8" lang="en"> <![endif]-->
<!--[if (gte IE 9)|!(IE)]><!-->
<html class="no-js" lang="en" <?php if(session()->get('rtl') == 1): ?> dir="rtl" <?php endif; ?> >
<!--<![endif]-->
<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <!--[if IE]>
    <meta http-equiv='X-UA-Compatible' content='IE=edge,chrome=1'/>
    <![endif]-->
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/bootstrap.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/owl.carousel.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/owl.theme.default.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/jquery.fancybox.min.css')); ?>"/>
    <?php echo $__env->yieldPushContent('extra-css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($themeTrue.'css/style.css')); ?>"/>
    <script src="<?php echo e(asset($themeTrue.'js/fontawesomepro.js')); ?>"></script>

    <?php echo $__env->yieldPushContent('style'); ?>

    <script src="<?php echo e(asset('assets/global/js/modernizr.custom.js')); ?>"></script>
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>

<body onload="preloder_function()" class="">

<!-- preloader_area_start -->
<div id="preloader">
    <div id="loader"></div>
</div>
<!-- preloader_area_end -->

<!-- Header_area_start -->
    <div class="header_area position-fixed">
    <!-- Nav_area_start -->
    <div class="nav_area">
        <nav class="navbar navbar-expand-lg">
            <div class="container custom_nav">
                <a class="logo" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(getFile(config('location.logoIcon.path').'logo.png')); ?>" alt="<?php echo app('translator')->get('Logo'); ?>"></a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                        data-bs-target="#navbarNavDropdown" aria-controls="navbarNavDropdown"
                        aria-expanded="false" aria-label="Toggle navigation">
                    <span class="bars"><i class="fal fa-bars"></i></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarNavDropdown">
                    <ul class="navbar-nav ms-auto text-center align-items-center">
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(menuActive('home')); ?>" aria-current="page"  href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(menuActive('about')); ?>" href="<?php echo e(route('about')); ?>"><?php echo app('translator')->get('About'); ?></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(menuActive('services')); ?>" href="<?php echo e(route('services')); ?>"><?php echo app('translator')->get('Service'); ?></a>
                        </li>

                        <li class="nav-item">
                            <a class="nav-link <?php echo e(menuActive('faq')); ?>" href="<?php echo e(route('faq')); ?>"><?php echo app('translator')->get('FAQ'); ?></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(menuActive('blog')); ?>" href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blog'); ?></a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo e(menuActive('contact')); ?>" href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                        </li>
                        <?php if(auth()->guard()->guest()): ?>
                            <li class="nav-item">
                                <a class="nav-link login_btn top-right-radius-0 <?php echo e(menuActive('login')); ?>" href="<?php echo e(route('login')); ?>"><?php echo app('translator')->get('login'); ?></a>
                            </li>
                        <?php else: ?>
                            <li class="nav-item">
                                <a class="nav-link login_btn top-right-radius-0 <?php echo e(menuActive('login')); ?>" href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
                            </li>
                        <?php endif; ?>

                    </ul>
                </div>
            </div>
        </nav>
    </div>
    <!-- Nav_area_end -->

</div>
<!-- Header_area_end -->

    <?php if(\Request::routeIs('home')): ?>
        <?php echo $__env->yieldPushContent('banner'); ?>
    <?php else: ?>
        <?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

<?php echo $__env->yieldContent('content'); ?>


<?php echo $__env->yieldPushContent('extra-content'); ?>


<?php echo $__env->make($theme.'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- arrow up -->
<a href="#" class="scroll_up">
    <i class="fal fa-chevron-double-up"></i>
</a>


<script src="<?php echo e(asset($themeTrue.'js/jquery-3.6.1.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/jquery.waypoints.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/owl.carousel.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/jquery.counterup.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/jquery.fancybox.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/notiflix-aio-2.7.0.min.js')); ?>"></script>
<?php echo $__env->yieldPushContent('extra-js'); ?>
<script src="<?php echo e(asset($themeTrue.'js/main.js')); ?>"></script>

<?php echo $__env->yieldPushContent('script'); ?>
<?php if(session()->has('success')): ?>
    <script>
        Notiflix.Notify.Success("<?php echo app('translator')->get(session('success')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('error')): ?>
    <script>
        Notiflix.Notify.Failure("<?php echo app('translator')->get(session('error')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('warning')): ?>
    <script>
        Notiflix.Notify.Warning("<?php echo app('translator')->get(session('warning')); ?>");
    </script>
<?php endif; ?>


<?php if($errors->any()): ?>
    <?php
        $collection = collect($errors->all());
        $errors = $collection->unique();
    ?>
    <script>
        "use strict";
        <?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            Notiflix.Notify.Failure("<?php echo e(trans($error)); ?>");
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </script>
<?php endif; ?>

<script>
    var root = document.querySelector(':root');
    
    
    
</script>
</body>
</html>
<?php /**PATH E:\xamp\htdocs\SMM_200823\project\resources\views/themes/lightorange/layouts/app.blade.php ENDPATH**/ ?>