<?php $__env->startSection('title', $provider->api_name); ?>
<?php $__env->startSection('content'); ?>

    <div class="card card-primary m-0 m-md-4 my-4 m-md-0">
        <div class="card-body">
            <h4 class="card-title mb-3">
                <a href="javascript:void(0)" class="import-multiple btn btn-primary text-white float-right" data-toggle="modal"
                                       data-target="#importMultipleMoldal"
                                       data-route="<?php echo e(route('admin.api.service.import.multi',['provider'=>$provider->id])); ?>">
                    <span><i class="fas fa-plus text-white pr-2"></i> <?php echo app('translator')->get('Add Bulk Service'); ?></span>
                </a>
            </h4>
            <div class="table-responsive ">
                <table class="table table-hover table-striped table-bordered">
                    <thead class="thead-primary">
                        <tr class="text-center">
                            <th scope="col" class="text-center check-box-width-50">
                                <input type="checkbox" class="form-check-input check-all tic-check check-all" name="check-all"
                                    id="check-all">
                                <label for="check-all" class="mt-3"></label>
                            </th>
                            <th scope="col"><?php echo app('translator')->get('ID'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Name'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Category'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Price'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Drip-Feed'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $apiServiceLists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="text-center check-box-width-50">
                                <input type="checkbox" id="chk-<?php echo e(@$service->service); ?>"
                                       class="form-check-input row-tic tic-check row-tic-<?php echo e(@$service->service); ?>"
                                       name="check" value="<?php echo e(@$service->service); ?>"
                                       data-id="<?php echo e($service->service); ?>">
                                <label for="chk-<?php echo e(@$service->service); ?>"></label>
                            </td>
                            <td class="text-center"><?php echo e(@$service->service); ?></td>
                            <td class="text-center">
                                <a href="javascript:void(0)" data-container="body"  data-toggle="popover" data-placement="top" data-content="<?php echo e(@$service->name); ?>">
                                    <?php echo e(\Str::limit(@$service->name, 30)); ?>

                                </a></td>
                            <td class="text-center"><?php echo e(@$service->category); ?></td>
                            <td class="text-center"><span class="text-dark"><?php echo e(@$service->rate); ?></span> <?php echo e($provider->currency); ?></td>
                            <td class="text-center">
                                <span
                                    class="badge badge-pill <?php echo e(@$service->dripfeed == 0 ? 'badge-danger' : 'badge-success'); ?>"><?php echo e(@$service->dripfeed == 0 ? 'Inactive' : 'Active'); ?>

                                </span>
                            </td>
                            <td class="text-center">
                                <div class="dropdown show dropup">
                                    <a class="dropdown-toggle" href="javascript:void(0)" id="dropdownMenuLink" data-toggle="dropdown"
                                       aria-haspopup="true" aria-expanded="false">
                                        <i class="fa fa-ellipsis-v" aria-hidden="true"></i>
                                    </a>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                        <a href="javascript:void(0)" class="dropdown-item import-single" data-toggle="modal"
                                           data-target="#importMoldal"
                                           data-route="<?php echo e(route('admin.api.service.import',['id'=>@$service->service,'name'=>@$service->name,'category'=>$service->category,'rate'=>$service->rate,'min'=>$service->min,'max'=>@$service->max,'dripfeed'=>@$service->dripfeed, 'provider'=>@$provider->id])); ?>">
                                            <i class="fas fa-plus text-success pr-2"></i> <?php echo app('translator')->get('Add Service'); ?></a>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="modal fade" id="importMoldal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog " role="document">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title"><?php echo app('translator')->get('Confirm Status Change'); ?> </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="" method="post" id="importForm">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Select Percentage Increase'); ?></label>
                            <select class="form-control" name="price_percentage_increase">
                                <option value="100" selected><?php echo app('translator')->get('100%'); ?></option>
                                <?php for($loop = 0; $loop <= 1000; $loop++): ?>
                                    <option value="<?php echo e($loop); ?>"><?php echo e($loop); ?> %</option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        <p><?php echo app('translator')->get('Are you really want to Import Service'); ?></p>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-dismiss="modal"><span><i
                                    class="fas fa-power-off"></i> <?php echo app('translator')->get('Cancel'); ?></span></button>
                        <button type="submit" class="btn btn-primary"><span><i
                                    class="fas fa-save"></i> <?php echo app('translator')->get('Confirm Import'); ?></span></button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div class="modal fade" id="importMultipleMoldal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog " role="document">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title"><?php echo app('translator')->get('Import Bulk Service'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="" method="post" id="importMultipleForm">
                    <?php echo csrf_field(); ?>

                    <div class="modal-body">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Bulk add limit'); ?></label>
                            <select class="form-control" name="import_quantity" id="selectedValue">
                                <option value="selectItem" class="selectedServices"><?php echo app('translator')->get('Add Selected Service'); ?></option>
                                <?php for($loop = 25; $loop <= 1000; $loop+=25): ?>
                                    <option value="<?php echo e($loop); ?>"><?php echo e($loop); ?></option>
                                <?php endfor; ?>
                                <option value="all">All</option>

                            </select>

                            <input type="hidden" value="" name="selectService" class="selectService">

                        </div>


                        <div class="form-group">
                            <label><?php echo app('translator')->get('Select Percentage Increase'); ?></label>
                            <select class="form-control" name="price_percentage_increase">
                                <option value="100" selected><?php echo app('translator')->get('100%'); ?></option>
                                <?php for($loop = 0; $loop <= 1000; $loop++): ?>
                                    <option value="<?php echo e($loop); ?>"><?php echo e($loop); ?> %</option>
                                <?php endfor; ?>
                            </select>
                        </div>

                        <p><?php echo app('translator')->get('Are you really want to Import All Service'); ?></p>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light" data-dismiss="modal"><span><i
                                    class="fas fa-power-off"></i> <?php echo app('translator')->get('Cancel'); ?></span></button>
                        <button type="submit" class="btn btn-primary"><span><i
                                    class="fas fa-save"></i> <?php echo app('translator')->get('Confirm Import'); ?></span></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
    <script>
        "use strict";
            $(document).on('click', '#check-all', function () {
                $('input:checkbox').not(this).prop('checked', this.checked);
            });

            $(document).on('change', ".row-tic", function () {
                let length = $(".row-tic").length;
                let checkedLength = $(".row-tic:checked").length;
                if (length == checkedLength) {
                    $('#check-all').prop('checked', true);
                } else {
                    $('#check-all').prop('checked', false);
                }
            });

            $(document).on('click', '.import-single', function () {
                let route = $(this).data('route');
                $('#importForm').attr('action', route);
            });


            $(document).on('click', '.import-multiple', function () {
                var allVals = [];
                $(".row-tic:checked").each(function () {
                    allVals.push($(this).attr('data-id'));
                });
                if (allVals.length > 0) {
                    var strIds = allVals.join(",");
                    $('select[name=import_quantity] option:selected').text(`Add ${allVals.length} Selected Service`)
                    $('.selectService').val(strIds)
                }
                else{
                    $('select[name=import_quantity] option:selected').text(`Add Selected Service`)
                }

                let route = $(this).data('route');

                $('#importMultipleForm').attr('action', route);
            });
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\SMM_200823\project\resources\views/admin/pages/services/show-api-services.blade.php ENDPATH**/ ?>