<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get($page_title); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.pages.order.partials.search-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <div class="card card-primary m-0 m-md-4 my-4 m-md-0 shadow">
        <div class="card-body">

            <div class="table-responsive">
                <table class="categories-show-table table table-hover table-striped table-bordered">
                    <thead class="thead-primary">
                    <tr>
                        <th scope="col" class="text-center">
                            <input type="checkbox" class="form-check-input check-all tic-check" name="check-all"
                                   id="check-all">
                            <label for="check-all"></label>
                        </th>
                        <th scope="col"><?php echo app('translator')->get('Order No.'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('User'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Order Details'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Created'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="text-center">
                                <input type="checkbox" id="chk-<?php echo e($order->id); ?>"
                                       class="form-check-input row-tic tic-check"
                                       name="check" value="<?php echo e($order->id); ?>" data-id="<?php echo e($order->id); ?>">
                                <label for="chk-<?php echo e($order->id); ?>"></label>
                            </td>
                            <td data-label="<?php echo app('translator')->get('Order No.'); ?>"><?php echo e($order->id); ?></td>
                            <td data-label="<?php echo app('translator')->get('User'); ?>">
                                <a href="<?php echo e(route('admin.user-edit',$order->user_id)); ?>" target="_blank">
                                    <?php echo app('translator')->get(optional($order->users)->username); ?>
                                </a>
                            </td>

                            <td data-label="<?php echo app('translator')->get('Order Details'); ?>">
                                <h5><?php echo app('translator')->get(optional($order->service)->service_title); ?> </h5>
                                <?php echo app('translator')->get('Link'); ?>: <?php echo app('translator')->get($order->link); ?><br>
                                <?php echo app('translator')->get('Quantity'); ?>: <?php echo app('translator')->get($order->quantity); ?><br>
                                <?php echo app('translator')->get("Start counter:"); ?> <?php echo e($order->start_counter); ?><br>
                                <?php echo app('translator')->get('Remains:'); ?> <?php echo e($order->remains); ?>

                            </td>
                            <td data-label="<?php echo app('translator')->get('Created'); ?>"><?php echo e(dateTime($order->created_at , 'd M Y, h:i A')); ?> </td>
                            <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                <?php if($order->status=='awaiting'): ?>
                                    <span
                                        class="badge badge-pill badge-warning"><?php echo e('Awaiting'); ?></span>
                                <?php elseif($order->status == 'pending'): ?>
                                    <span
                                        class="badge badge-pill badge-info"><?php echo e('Pending'); ?></span>
                                <?php elseif($order->status == 'processing'): ?>
                                    <span
                                        class="badge badge-pill badge-info"><?php echo e('Processing'); ?></span>
                                <?php elseif($order->status == 'progress'): ?>
                                    <span
                                        class="badge badge-pill badge-warning"><?php echo e('In progress'); ?></span>
                                <?php elseif($order->status == 'completed'): ?>
                                    <span
                                        class="badge badge-pill badge-success"><?php echo e('Completed'); ?></span>
                                <?php elseif($order->status == 'partial'): ?>
                                    <span
                                        class="badge badge-pill badge-warning"><?php echo e('Partial'); ?></span>
                                <?php elseif($order->status == 'canceled'): ?>
                                    <span
                                        class="badge badge-pill badge-danger"><?php echo e('Canceled'); ?></span>
                                <?php elseif($order->status == 'refunded'): ?>
                                    <span
                                        class="badge badge-pill badge-danger"><?php echo e('Refunded'); ?></span>
                                <?php endif; ?>

                                <?php if(isset($order->refill_status) && ($order->refill_status != 'completed' || $order->refill_status != 'partial' || $order->refill_status != 'canceled' || $order->refill_status != 'refunded')): ?>
                                    <p class="badge badge-pill badge-warning"><?php echo e(trans('Refilling')); ?></p>
                                <?php endif; ?>
                            </td>
                            <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                <div class="dropdown show dropup">
                                    <a class="dropdown-toggle p-3" href="#" id="dropdownMenuLink" data-toggle="dropdown"
                                       aria-haspopup="true" aria-expanded="false">
                                        <i class="fa fa-ellipsis-v" aria-hidden="true"></i>
                                    </a>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                        <a class="dropdown-item"
                                           href="<?php echo e(route('admin.order.edit',[$order->id])); ?>"><i
                                                class="fa fa-edit text-warning pr-2"
                                                aria-hidden="true"></i> <?php echo app('translator')->get('Edit'); ?>
                                        </a>

                                        <a href="javascript:void(0)" class="dropdown-item status-change"
                                           data-toggle="modal"
                                           data-target="#statusMoldal"
                                           data-route="<?php echo e(route('admin.order.status.change',['id'=>$order->id])); ?>">
                                            <i class="fa fa-check pr-2 text-success"
                                               aria-hidden="true"></i> <?php echo app('translator')->get('Change Status'); ?>
                                        </a>

                                        <?php if(isset($order->refill_status) && ($order->refill_status != 'completed' || $order->refill_status != 'partial' || $order->refill_status != 'canceled' || $order->refill_status != 'refunded')): ?>
                                            <a href="javascript:void(0)" class="dropdown-item refill-status-change"
                                               data-toggle="modal"
                                               data-target="#refillStatusMoldal"
                                               data-route="<?php echo e(route('admin.order.refill-status.change',['id' => $order->id])); ?>">
                                                <i class="fa fa-check pr-2 text-success"
                                                   aria-hidden="true"></i> <?php echo app('translator')->get('Change Refill Status'); ?>
                                            </a>
                                        <?php endif; ?>

                                        <a href="javascript:void(0)" class="dropdown-item delete-order"
                                           data-toggle="modal"
                                           data-target="#deleteModal"
                                           data-route="<?php echo e(route('admin.order.destroy',[$order->id])); ?>">
                                            <i class="fa fa-trash-alt pr-2 text-danger"
                                               aria-hidden="true"></i> <?php echo app('translator')->get('Delete'); ?>
                                        </a>

                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($orders->appends($_GET)->links()); ?>

            </div>
        </div>
    </div>

    <?php echo $__env->make('admin.pages.order.partials.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/jquery-ui.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script>
            "use strict";
            var status = null;

            $(document).on('click', '#check-all', function () {
                $('input:checkbox').not(this).prop('checked', this.checked);
            });
            $(document).on('change', ".row-tic", function () {
                let length = $(".row-tic").length;
                let checkedLength = $(".row-tic:checked").length;
                if (length == checkedLength) {
                    $('#check-all').prop('checked', true);
                } else {
                    $('#check-all').prop('checked', false);
                }
            });

            $(document).on('click', '.status-change', function () {
                let route = $(this).data('route');
                $('#statusForm').attr('action', route);
            });

            $(document).on('click', '.refill-status-change', function () {
                let route = $(this).data('route');
                $('#refillStatusForm').attr('action', route);
            });

            $(document).on('click', '.delete-order', function () {
                let route = $(this).data('route');
                $('#deleteConfirm').attr('action', route);
            });

            $(document).on('click', '.dropdown-menu', function (e) {
                e.stopPropagation();
            });


            //all checked click function

            $(document).on('click', '.usersOrderChangeStatus', function () {
                status = $(this).data('status');
                $('.text-status').text(status)
            });

            $(document).on('click', '.awaiting-yes', function (e) {
                e.preventDefault();
                var allVals = [];

                $(".row-tic:checked").each(function () {
                    allVals.push($(this).attr('data-id'));
                });


                var strIds = allVals.join(",");


                $.ajax({
                    headers: {'X-CSRF-TOKEN': $('meta[name="csrf_token"]').attr('content')},
                    url: "<?php echo e(route('admin.usersOrderChangeStatus')); ?>",
                    data: {
                        strIds,
                        status
                    },
                    datatType: 'json',
                    type: "get",
                    success: function (data) {
                        location.reload();
                    }
                });
            })


    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xamp\htdocs\SMM_200823\project\resources\views/admin/pages/order/show.blade.php ENDPATH**/ ?>